/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.command.HMCCommandsTask;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.p.sa.ServiceAgentUtils;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;

public class PIChangeServiceAgentConfig {
    public static final String CMD_LINE_BUNDLE = "PIHscCmdLineBundle";
    static final String ENABLE_OPERATION = "enable";
    static final String DISABLE_OPERATION = "disable";
    static final String CUSTOMER_EMAIL_NOTIFICATION = "email";
    static final String FTP_FIREWALL_TYPE = "ftpfirewall";
    static final String FTP_OFFLDSERVER_TYPE = "ftpoffload";
    static final String CEN_SETSMTP_OPERATION = "setsmtp";
    static final String CEN_ADDADDRESS_OPERATION = "add";
    static final String CEN_REMOVEADDRESS_OPERATION = "remove";
    static final String CEN_TESTADDRESS_OPERATION = "test";
    static final String CEN_NOTIFYTYPE_ALL = "all";
    static final String CEN_NOTIFYTYPE_CALLHOME = "callhome";
    static final String FTPFW_ADDEXCLUDEADDRESS_OPERATION = "add";
    static final String FTPFW_REMOVEEXCLUDEADDRESS_OPERATION = "remove";
    static final String FTP_PASSIVEON_OPERATION = "on";
    static final String FTP_PASSIVEOFF_OPERATION = "off";
    static final String FTP_PASSIVEOPTIONAL_OPERATION = "optional";
    private static final String DEFAULT_SMTP_PORT = "25";
    private static final int PORT_MIN = 1;
    private static final int PORT_MAX = 65536;
    private static final int FW_TYPE_MIN = 0;
    private static final int FW_TYPE_MAX = 7;
    private static HashMap c_validParms;

    private static boolean isPortValid(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return n >= 1 && n <= 65536;
    }

    private static HashMap getValidParms() {
        if (c_validParms == null) {
            c_validParms = new HashMap(24, 0.5f);
            c_validParms.put("-t", null);
            c_validParms.put("-o", null);
            c_validParms.put("-h", null);
            c_validParms.put("-p", null);
            c_validParms.put("-a", null);
            c_validParms.put("--events", null);
            c_validParms.put("--fwtype", null);
            c_validParms.put("-u", null);
            c_validParms.put("--passwd", null);
            c_validParms.put("--passive", null);
            c_validParms.put("-n", null);
            c_validParms.put("-d", null);
        }
        return c_validParms;
    }

    private static String readPassword(String string, PrintStream printStream) throws PIHscClientException {
        String string2 = null;
        try {
            String string3 = System.getProperty("HMCtty.name");
            boolean bl = string3 != null && string3.length() > 0;
            EExecResult eExecResult = null;
            String string4 = null;
            String string5 = null;
            if (bl) {
                eExecResult = EExec.Exec((String)("stty --save --file=" + string3));
                string4 = "stty --file=" + string3 + " " + eExecResult.stdout;
                string5 = "stty --file=" + string3 + " -echo";
            }
            printStream.println(HSCResourceBundleUtil.getMessage(CMD_LINE_BUNDLE, "ENTER_OLD_PASSWORD", null, new String[]{string}));
            if (bl) {
                eExecResult = EExec.Exec(string5);
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            string2 = bufferedReader.readLine().trim();
            bufferedReader.close();
            if (bl) {
                eExecResult = EExec.Exec((String)string4);
            }
        }
        catch (IOException iOException) {
            throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "ERROR_READING_PASSWORD");
        }
        return string2;
    }

    public static void printHelp(PrintStream printStream) {
        printStream.print('\u0000');
        printStream.println(HSCResourceBundleUtil.getMessage(CMD_LINE_BUNDLE, "CHSACFG_HELP"));
    }

    public static void main(String[] stringArray) {
        int n;
        block13: {
            PrintStream printStream = System.out;
            if (stringArray.length == 0) {
                PIChangeServiceAgentConfig.printHelp(printStream);
                return;
            }
            n = 0;
            PIHscUtil.initHscUtil(3);
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("--help")) {
                    PIChangeServiceAgentConfig.printHelp(printStream);
                    return;
                }
                arrayList.add(stringArray[i]);
            }
            try {
                HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, PIChangeServiceAgentConfig.getValidParms());
                String string = (String)hashMap.get("-t");
                if (string == null) {
                    throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "REQUIRED_PARMS_ERROR", new String[]{"-t"}, null);
                }
                if (string.equals(CUSTOMER_EMAIL_NOTIFICATION)) {
                    new CustomerEmailNotification(hashMap).invoke();
                    break block13;
                }
                if (string.equals(FTP_FIREWALL_TYPE)) {
                    new FtpFirewallSettings(printStream, hashMap).invoke();
                    break block13;
                }
                if (string.equals(FTP_OFFLDSERVER_TYPE)) {
                    new FtpOffloadServer(printStream, hashMap).invoke();
                    break block13;
                }
                throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", new String[]{"-t"}, null);
            }
            catch (PIHscClientException pIHscClientException) {
                printStream.print('\u0001');
                if ("8000".equals(pIHscClientException.getHscExId())) {
                    printStream.println(pIHscClientException.getMessage());
                } else {
                    pIHscClientException.printStackTrace(System.out);
                    String string = pIHscClientException.getMessage();
                    if (string == null || string.length() == 0) {
                        string = HSCResourceBundleUtil.getMessage(CMD_LINE_BUNDLE, "COMMAND_LINE_ERROR");
                    }
                    printStream.println(string);
                }
                n = 1;
            }
            catch (Exception exception) {
                printStream.print('\u0001');
                exception.printStackTrace(System.out);
                String string = HSCResourceBundleUtil.getMessage(CMD_LINE_BUNDLE, "COMMAND_LINE_ERROR");
                printStream.println(string);
                n = 1;
            }
        }
        System.exit(n);
    }

    public static class FtpOffloadServer
    extends HMCCommandsTask {
        private String m_operation;
        private String m_destination;
        private String m_directory;
        private String m_user;
        private String m_password;
        private String m_port;
        private String m_passive;
        private transient PrintStream m_out;

        private FtpOffloadServer(PrintStream printStream, HashMap hashMap) {
            this.m_out = printStream;
            this.mapParameters(hashMap);
        }

        private void mapParameters(HashMap hashMap) {
            this.m_operation = (String)hashMap.get("-o");
            this.m_destination = (String)hashMap.get("-h");
            this.m_directory = (String)hashMap.get("-d");
            this.m_user = (String)hashMap.get("-u");
            this.m_password = (String)hashMap.get("--passwd");
            this.m_port = (String)hashMap.get("-p");
            this.m_passive = (String)hashMap.get("--passive");
        }

        public void performCommand() throws PIHscClientException {
            if (this.m_operation != null) {
                if (this.m_operation.equals(PIChangeServiceAgentConfig.ENABLE_OPERATION)) {
                    ServiceAgentUtils.setFtpOffLoadSetting((boolean)true);
                } else if (this.m_operation.equals(PIChangeServiceAgentConfig.DISABLE_OPERATION)) {
                    ServiceAgentUtils.setFtpOffLoadSetting((boolean)false);
                } else {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", new String[]{"-o"}, null);
                }
            }
            if (this.m_destination != null) {
                if (this.m_destination.length() == 0) {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", new String[]{"-h"}, null);
                }
                ServiceAgentUtils.setFtpServerName((String)this.m_destination);
            }
            if (this.m_directory != null) {
                if (this.m_directory.length() == 0) {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", new String[]{"-d"}, null);
                }
                ServiceAgentUtils.setFtpServerDirectory((String)this.m_directory);
            }
            if (this.m_user != null) {
                if (this.m_user.length() == 0) {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", new String[]{"-u"}, null);
                }
                ServiceAgentUtils.setFtpServerUserName((String)this.m_user);
            }
            if (this.m_password != null) {
                ServiceAgentUtils.setFtpServerUserPassword((String)this.m_password);
            }
            if (this.m_port != null) {
                if (!PIChangeServiceAgentConfig.isPortValid(this.m_port)) {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", new String[]{"-p"}, null);
                }
                ServiceAgentUtils.setFtpPort((int)Integer.parseInt(this.m_port));
            }
            if (this.m_passive != null) {
                if (this.m_passive.equals(PIChangeServiceAgentConfig.FTP_PASSIVEON_OPERATION)) {
                    ServiceAgentUtils.setFtpServerPassiveMode((String)PIChangeServiceAgentConfig.FTP_PASSIVEON_OPERATION);
                } else if (this.m_passive.equals(PIChangeServiceAgentConfig.FTP_PASSIVEOFF_OPERATION)) {
                    ServiceAgentUtils.setFtpServerPassiveMode((String)PIChangeServiceAgentConfig.FTP_PASSIVEOFF_OPERATION);
                } else {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", new String[]{"--passive"}, null);
                }
            }
        }

        public void invoke() throws Exception {
            if (this.m_password != null && this.m_password.length() == 0) {
                this.m_password = PIChangeServiceAgentConfig.readPassword("FTP Offload Server User", this.m_out);
            }
            this.invokeViaTasklet();
        }
    }

    public static class FtpFirewallSettings
    extends HMCCommandsTask {
        public static final char EXCLUSION_LIST_DELIM = ',';
        private String m_type;
        private String m_host;
        private String m_user;
        private String m_password;
        private String m_port;
        private String m_passive;
        private String m_operation;
        private String m_domain;
        private transient PrintStream m_out;

        private FtpFirewallSettings(PrintStream printStream, HashMap hashMap) {
            this.m_out = printStream;
            this.mapParameters(hashMap);
        }

        private void mapParameters(HashMap hashMap) {
            this.m_type = (String)hashMap.get("--fwtype");
            this.m_host = (String)hashMap.get("-h");
            this.m_user = (String)hashMap.get("-u");
            this.m_password = (String)hashMap.get("--passwd");
            this.m_port = (String)hashMap.get("-p");
            this.m_passive = (String)hashMap.get("--passive");
            this.m_operation = (String)hashMap.get("-o");
            this.m_domain = (String)hashMap.get("-n");
        }

        public void performCommand() throws PIHscClientException {
            if (this.m_type != null) {
                int n = 0;
                boolean bl = true;
                try {
                    n = Integer.parseInt(this.m_type);
                    bl = n >= 0 && n <= 7;
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
                if (!bl) {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", new String[]{"--fwtype"}, null);
                }
                ServiceAgentUtils.setFtpFirewallType((String)this.m_type);
            }
            if (this.m_host != null) {
                if (this.m_host.length() == 0) {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", new String[]{"-h"}, null);
                }
                ServiceAgentUtils.setFtpFirewallHostName((String)this.m_host);
            }
            if (this.m_user != null) {
                if (this.m_user.length() == 0) {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", new String[]{"-u"}, null);
                }
                ServiceAgentUtils.setFtpFirewallUserName((String)this.m_user);
            }
            if (this.m_password != null) {
                ServiceAgentUtils.setFtpFirewallUserPassword((String)this.m_password);
            }
            if (this.m_port != null) {
                if (!PIChangeServiceAgentConfig.isPortValid(this.m_port)) {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", new String[]{"-p"}, null);
                }
                ServiceAgentUtils.setFtpFirewallPort((int)Integer.parseInt(this.m_port));
            }
            if (this.m_passive != null) {
                if (this.m_passive.equals(PIChangeServiceAgentConfig.FTP_PASSIVEON_OPERATION)) {
                    ServiceAgentUtils.setFtpFirewallPassiveMode((String)PIChangeServiceAgentConfig.FTP_PASSIVEON_OPERATION);
                } else if (this.m_passive.equals(PIChangeServiceAgentConfig.FTP_PASSIVEOFF_OPERATION)) {
                    ServiceAgentUtils.setFtpFirewallPassiveMode((String)PIChangeServiceAgentConfig.FTP_PASSIVEOFF_OPERATION);
                } else if (this.m_passive.equals(PIChangeServiceAgentConfig.FTP_PASSIVEOPTIONAL_OPERATION)) {
                    ServiceAgentUtils.setFtpFirewallPassiveMode((String)PIChangeServiceAgentConfig.FTP_PASSIVEOPTIONAL_OPERATION);
                } else {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", new String[]{"--passive"}, null);
                }
            }
            if (this.m_operation != null) {
                if (this.m_domain == null) {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "REQUIRED_PARMS_ERROR", new String[]{"-n"}, null);
                }
                if (this.m_operation.equals("add")) {
                    ServiceAgentUtils.setFtpFirewallExclusionList((String)this.addToList(this.m_domain));
                } else if (this.m_operation.equals("remove")) {
                    ServiceAgentUtils.setFtpFirewallExclusionList((String)this.removeFromList(this.m_domain));
                } else {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", new String[]{"-o"}, null);
                }
            }
        }

        public void invoke() throws Exception {
            if (this.m_password != null && this.m_password.length() == 0) {
                this.m_password = PIChangeServiceAgentConfig.readPassword("FTP Firewall User", this.m_out);
            }
            this.invokeViaTasklet();
        }

        private String addToList(String string) {
            String string2 = ServiceAgentUtils.getFtpFirewallExclusionList().replaceAll(" ", "");
            if (string2.indexOf(string) >= 0) {
                return string2;
            }
            return string2.length() == 0 ? string : string2 + ',' + string;
        }

        private String removeFromList(String string) {
            String string2 = ServiceAgentUtils.getFtpFirewallExclusionList().replaceAll(" ", "");
            int n = 0;
            n = string2.indexOf(string);
            if (n < 0) {
                return string2;
            }
            String string3 = n == 0 ? string : ',' + string;
            if ((string2 = string2.replaceFirst(string3, "")).length() > 0 && string2.charAt(0) == ',') {
                string2 = string2.substring(1, string2.length());
            }
            return string2;
        }
    }

    public static class CustomerEmailNotification
    extends HMCCommandsTask {
        private static final int RC_INTERNAL_ERROR = 1;
        private static final int RC_ADDRESS_EXISTS = 2;
        private static final int RC_ADDRESS_NOT_FOUND = 3;
        private static final int RC_EMAIL_SEND_ERROR = 4;
        private String m_commandOperation;
        private String m_hostName;
        private String m_portNumber;
        private String m_emailAddress;
        private String m_notifyType;

        private CustomerEmailNotification(HashMap hashMap) {
            this.mapParameters(hashMap);
        }

        private void mapParameters(HashMap hashMap) {
            this.m_commandOperation = (String)hashMap.get("-o");
            this.m_hostName = (String)hashMap.get("-h");
            this.m_emailAddress = (String)hashMap.get("-a");
            String string = (String)hashMap.get("-p");
            this.m_portNumber = string != null ? string : PIChangeServiceAgentConfig.DEFAULT_SMTP_PORT;
            string = (String)hashMap.get("--events");
            this.m_notifyType = string != null ? string : PIChangeServiceAgentConfig.CEN_NOTIFYTYPE_ALL;
        }

        private int doEmailCommandEnable() {
            if (ServiceAgentUtils.setEmailSetting((boolean)true) == 0) {
                return 0;
            }
            return 1;
        }

        private int doEmailCommandDisable() {
            if (ServiceAgentUtils.setEmailSetting((boolean)false) == 0) {
                return 0;
            }
            return 1;
        }

        private int doEmailCommandSetSmtp() {
            if (ServiceAgentUtils.setEmailSMTPServer((String)this.m_hostName) == 0 && ServiceAgentUtils.setEmailPort((int)Integer.parseInt(this.m_portNumber)) == 0) {
                return 0;
            }
            return 1;
        }

        private int doEmailCommandAddAddress() {
            String string = this.m_notifyType.equalsIgnoreCase(PIChangeServiceAgentConfig.CEN_NOTIFYTYPE_CALLHOME) ? "ESA.CallHomeOnly" : "ESA.All";
            switch (ServiceAgentUtils.addEmailEntry((String)this.m_emailAddress, (String)string)) {
                case 3: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
            }
            return 0;
        }

        private int doEmailCommandRemoveAddress() {
            int n = 0;
            n = this.m_emailAddress.equalsIgnoreCase(PIChangeServiceAgentConfig.CEN_NOTIFYTYPE_ALL) ? ServiceAgentUtils.removeAllEmailEntries() : ServiceAgentUtils.removeEmailEntry((String)this.m_emailAddress.toUpperCase());
            switch (n) {
                case 3: {
                    return 1;
                }
                case 2: {
                    return 3;
                }
            }
            return 0;
        }

        private int doEmailCommandTestAddress() {
            int n = 0;
            LocalizableText localizableText = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.TestEmailSubject");
            LocalizableText localizableText2 = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.TestEmailMessage");
            n = this.m_emailAddress.equalsIgnoreCase(PIChangeServiceAgentConfig.CEN_NOTIFYTYPE_ALL) ? ServiceAgentUtils.ESASendEmailMsg((String)"Y", (LocalizableText)localizableText, (LocalizableText)localizableText2) : ServiceAgentUtils.sendEmailMsgToAddresses((String[])new String[]{this.m_emailAddress}, (LocalizableText)localizableText, (LocalizableText)localizableText2);
            switch (n) {
                case 2: {
                    return 3;
                }
                case 3: {
                    return 4;
                }
            }
            return 0;
        }

        public void performCommand() throws PIHscClientException {
            if (this.m_commandOperation == null) {
                throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "REQUIRED_PARMS_ERROR", new String[]{"-o"}, null);
            }
            if (this.m_commandOperation.equals(PIChangeServiceAgentConfig.ENABLE_OPERATION)) {
                if (this.m_hostName != null) {
                    if (this.m_hostName.length() > 0) {
                        if (!PIChangeServiceAgentConfig.isPortValid(this.m_portNumber)) {
                            throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", new String[]{"-p"}, null);
                        }
                        if (this.doEmailCommandSetSmtp() == 1) {
                            throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "COMMAND_LINE_ERROR", new String[0], null);
                        }
                    } else {
                        throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", new String[]{"-h"}, null);
                    }
                }
                if (this.doEmailCommandEnable() == 1) {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "COMMAND_LINE_ERROR", new String[0], null);
                }
            } else if (this.m_commandOperation.equals(PIChangeServiceAgentConfig.DISABLE_OPERATION)) {
                if (this.doEmailCommandDisable() == 1) {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "COMMAND_LINE_ERROR", new String[0], null);
                }
            } else if (this.m_commandOperation.equals(PIChangeServiceAgentConfig.CEN_SETSMTP_OPERATION)) {
                if (this.m_hostName == null) {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "REQUIRED_PARMS_ERROR", new String[]{"-h"}, null);
                }
                if (this.m_hostName.length() == 0) {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", new String[]{"-h"}, null);
                }
                if (!PIChangeServiceAgentConfig.isPortValid(this.m_portNumber)) {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", new String[]{"-p"}, null);
                }
                if (this.doEmailCommandSetSmtp() == 1) {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "COMMAND_LINE_ERROR", new String[0], null);
                }
            } else if (this.m_commandOperation.equals("add")) {
                if (this.m_emailAddress == null) {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "REQUIRED_PARMS_ERROR", new String[]{"-a"}, null);
                }
                if (this.m_emailAddress.length() == 0) {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", new String[]{"-a"}, null);
                }
                if (!this.m_notifyType.equalsIgnoreCase(PIChangeServiceAgentConfig.CEN_NOTIFYTYPE_ALL) && !this.m_notifyType.equalsIgnoreCase(PIChangeServiceAgentConfig.CEN_NOTIFYTYPE_CALLHOME)) {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", new String[]{"--events"}, null);
                }
                switch (this.doEmailCommandAddAddress()) {
                    case 1: {
                        throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "COMMAND_LINE_ERROR", new String[0], null);
                    }
                    case 2: {
                        throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "EMAIL_ADDRESS_ALREADY_EXISTS", new String[0], null);
                    }
                }
            } else if (this.m_commandOperation.equals("remove")) {
                if (this.m_emailAddress == null) {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "REQUIRED_PARMS_ERROR", new String[]{"-a"}, null);
                }
                if (this.m_emailAddress.length() == 0) {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", new String[]{"-a"}, null);
                }
                switch (this.doEmailCommandRemoveAddress()) {
                    case 1: {
                        throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "COMMAND_LINE_ERROR", new String[0], null);
                    }
                    case 3: {
                        throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "EMAIL_ADDRESS_NOT_FOUND", new String[0], null);
                    }
                }
            } else if (this.m_commandOperation.equals(PIChangeServiceAgentConfig.CEN_TESTADDRESS_OPERATION)) {
                if (this.m_emailAddress == null) {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "REQUIRED_PARMS_ERROR", new String[]{"-a"}, null);
                }
                if (this.m_emailAddress.length() == 0) {
                    throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", new String[]{"-a"}, null);
                }
                switch (this.doEmailCommandTestAddress()) {
                    case 3: {
                        throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "EMAIL_ADDRESS_NOT_FOUND", new String[0], null);
                    }
                    case 4: {
                        throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "EMAIL_SEND_ERROR", new String[0], null);
                    }
                }
            } else {
                throw new PIHscClientException("8000", PIChangeServiceAgentConfig.CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", new String[]{"-o"}, null);
            }
        }

        public void invoke() throws Exception {
            this.invokeViaTasklet();
        }
    }
}

